﻿namespace Microsoft.Samples.PlanMyNight.AddIns.EmailItinerary.Notifications
{
    using System.IO;

    public class FileTemplateReader : ITemplateReader
    {
        private readonly string basePath;

        public FileTemplateReader(string basePath)
        {
            this.basePath = basePath;
        }

        public string RetrieveTemplate(string templateName)
        {
            try
            {
                return File.ReadAllText(Path.Combine(this.basePath, string.Concat(templateName, ".txt")));
            }
            catch
            {
                return null;
            }
        }
    }
}
